<?php
/**
 * Content Tab "Tour Variable"
 */

global $post;
foreach ( TravelPhysTab::$field_arr as $key => $val_default ) {
	${$key} = get_post_meta( $post->ID, '_' . $key, true ) ? get_post_meta( $post->ID, '_' . $key, true ) : $val_default;
}

$tour_variation_item_structure_fields = apply_filters(
	'tour_variation_item_structure_fields',
	array(
		'label_variation' => array(
			'label' => __( 'Label Variation', 'travel-booking' ),
			'types' => 'input_text'
		),
		'enable'          => array(
			'label' => __( 'Enable item', 'travel-booking' ),
			'types' => array(
				1 => array( 'label' => __( 'Yes' ) ),
				0 => array( 'label' => __( 'No' ) ),
			)
		),
		'type_variation'  => array(
			'label' => __( 'Type Variation', 'travel-booking' ),
			'types' => array(
				'select'   => array( 'label' => __( 'Select' ) ),
				'checkbox' => array( 'label' => __( 'Checkbox' ) ),
				'radio'    => array( 'label' => __( 'Radio' ) ),
				'quantity' => array( 'label' => __( 'Quantity' ) ),
			)
		),
		'set_price'       => array(
			'label' => __( 'Set price or Only show', 'travel-booking' ),
			'types' => array(
				0 => array( 'label' => 'Only Show' ),
				1 => array( 'label' => 'Set price' )
			)
		),
		'required'        => array(
			'label' => __( 'Required', 'travel-booking' ),
			'types' => array(
				1 => array( 'label' => 'Yes' ),
				0 => array( 'label' => 'No' )
			)
		),

		/*** For Attribute ***/
		'variation_attr'  => array(
			'label' => array( 'label' => __( 'Label', 'travel-booking' ), 'types' => 'input_text' ),
			'price' => array( 'label' => __( 'Price', 'travel-booking' ), 'types' => 'input_text' ),
			'des'   => array( 'label' => __( 'Description', 'travel-booking' ), 'types' => 'input_textarea' ),
		)
	)
);

$tour_variants_data_obj = json_decode( $tour_variations_options );
?>

<div id="tour_variation_phys" class="panel woocommerce_options_panel">
	<div class="form-field">
		<p class="tour-variation-enable">
			<strong><?php echo esc_html__( 'Enable tour variation', 'travel-booking' ); ?></strong>
			<select name="tour_variation_enable">
				<?php
				if ( $tour_variation_enable ) {
					echo '<option value="1" selected>' . __( 'Yes', 'travel - booking' ) . '</option>';
					echo '<option value="0">' . __( 'No', 'travel - booking' ) . '</option>';
				} else {
					echo '<option value="1">' . __( 'Yes', 'travel - booking' ) . '</option>';
					echo '<option value="0" selected>' . __( 'No', 'travel - booking' ) . '</option>';
				}
				?>
			</select>
		</p>
	</div>
	<hr>
	<div class="form-field">
		<div class="button-action">
			<button id="new-tour-variations" class="btn"><?php _e( 'Add new variant', 'travel-booking' ) ?></button>
			<button id="save-tour-variations" class="btn"><?php _e( 'Save', 'travel-booking' ) ?></button>
		</div>

		<div class="wrapper-tour-variants">
			<?php
			if ( ! is_null( $tour_variants_data_obj ) && count( array( $tour_variants_data_obj ) ) > 0 ) {
				foreach ( $tour_variants_data_obj as $k => $tour_variant_item ) {
					$toggle = 'toggle-up';
					if ( ! isset( $tour_variant_item->toggle ) ) {
						$toggle = 'toggle-down';
					} else {
						$toggle = $tour_variant_item->toggle;
					}
					?>
					<div class="wrapper-tour-variant-item <?php echo $toggle == 'toggle-down' ? '' : 'open' ?>">
						<div class="header-tour-variation-item">
							<h3><?php echo $tour_variant_item->label_variation !== '' ? $tour_variant_item->label_variation : 'Item' ?></h3>
							<span class="toggle-variation-item <?php echo $toggle ?>" aria-hidden="true"></span>
						</div>
						<div class="tour-variant-item" data-variation-id="<?php echo $k ?>" style="<?php echo $toggle == 'toggle-down' ? 'display: none' : '' ?>">
							<?php
							foreach ( $tour_variation_item_structure_fields as $k_field => $v_field ) {

								if ( $k_field !== 'variation_attr' ) {
									echo '<p class="variation-field"><span>' . $v_field['label'] . '</span>';

									if ( is_array( $v_field['types'] ) ) {
										echo '<select class="field"  name="' . $k_field . '">';
										foreach ( $v_field['types'] as $k_type => $v_type ) {
											$selected = '';
											if ( $tour_variant_item->{$k_field} == $k_type ) {
												$selected = 'selected';
											}
											echo '<option value="' . $k_type . '" ' . $selected . '>' . $v_type['label'] . '</option>';
										}
										echo '</select>';
									} elseif ( $v_field['types'] === 'input_text' ) {
										echo '<input type="text" name="' . $k_field . '" value="' . $tour_variant_item->{$k_field} . '" class="field" >';
									}

									echo '</p>';
								} else {
									echo '<div class="variation-field-attrs" name="' . $k_field . '">';
									echo '<button class="new-variation-attr btn">Add new attribute</button>';
									echo '<div class="wrapper-tour-variation-attribute">';
									foreach ( $tour_variant_item->{$k_field} as $k_variation_attr => $v_variation_attr ) {
										echo '<ul class="tour-variation-attribute" data-attr-id="' . $k_variation_attr . '">';
										echo '<li><h4><strong>Attribute:</strong></h4></li>';
										foreach ( $v_field as $k_attr => $v_attr ) {
											echo '<li>';
											echo '<span>' . $v_attr['label'] . '</span>';
											echo '<input class="field" type="text" name="' . $k_attr . '" value="' . $v_variation_attr->{$k_attr} . '" >';
											echo '</li>';
										}
										echo '<span class="remove-variant-attr dashicons dashicons-no-alt" title="Remove Attribute"></span>';
										echo '</ul>';
									}
									echo '</div>';
									echo '</div>';
								}
							}
							?>
							<span class="remove-variant dashicons dashicons-no" title="<?php echo __( 'Remove Variation', 'travel-booking' ) ?>"></span>
						</div>
					</div>
					<?php
				}
			}
			?>
		</div>

		<p class="errors"></p>
		<input type="hidden" name="tour_variations_options" value="<?php echo $tour_variations_options != '' ? htmlspecialchars( $tour_variations_options ) : '' ?>">
		<input type="hidden" name="tour_variation_item_structure_fields" value="<?php echo htmlspecialchars( json_encode( $tour_variation_item_structure_fields ) ) ?>">
	</div>
</div>